

  /*
   *  Object %CRYS_C2_OneWayFunc    : %
   *  State           :  %state%
   *  Creation date   :  Feb. 27 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_C2_OneWayFunc.c#1:csrc:
   *  \author R.Levin .
   *
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

/* .............. CRYS level includes ................. */

#include "DX_VOS_Mem.h"
#include "CRYS_C2_error.h"
#include "CRYS.h"

/* .............. LLF level includes .................. */

 
/************************ Defines **********************8***************/


/* canceling the PC-lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums *****************************************/

/************************ MACROS ****************************************/

/************************ Global Data ***********************************/

/************* Private function prototype *******************************/


/************************ Public Functions ******************************/


  
/*****************************************************************************************************/                         
/** 
 * @brief This function is used to perform C2 One Way operation on 64-bit block of data.
 *
 *        The function executes the following major steps:
 *
 *        1.Checks the validation of all of the inputs of the function.
 *          If one of the received parameters is not valid it shall return an error. 
 *          The checkers that are run over the received parameters:
 *             - verifying that the pointers are not DX_NULL.
 *        2.Executing the C2 ECB encrypt operation of Data2 with key = Data1 by calling the 
 *          low level function LLF_C2_ECB_Encrypt.
 *        3.Performs XOR of encrypt output with Data2 and output this result.
 *
 *        4.Exit.  
 *
 * @param[in] Data1_ptr -  The pointer to the buffer of the input Data1 used as encrypting key. 
 *                         The pointer need to be aligned to 32 bits.
 *
 * @param[in] Data2 - The pointer to the 64-bits buffer of the input Data2.
 *                    The pointer need to be aligned to 32 bits.
 *
 * @param[in/out] DataOut_ptr - The pointer to the 64-bits buffer for output data.
 *                              The pointer need to be aligned to 32 bits. 
 *                               
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                       value from CRYS_C2_error.h
 */
  CEXPORT_C CRYSError_t  CRYS_C2_OneWayFunc( CRYS_C2_Key_t           Data1_ptr,     
                                             CRYS_C2_BLOCK_BYTES_t   Data2_ptr,
                                             CRYS_C2_BLOCK_BYTES_t   DataOut_ptr )                                

 {                              
   
   /* FUNCTION DECLARATIONS */

   /* The return error identifiers */
   CRYSError_t Error;
   
    /* FUNCTION LOGIC */
  
   /* ............... local initializations .............................. */
   /* -------------------------------------------------------------------- */
   
   /* initializing the Error to O.K */
   Error = CRYS_OK;
 
    
   return Error;
   
 
}/* END OF CRYS_C2_CipherBlock */ 


